/*
 * FFT.c
 *
 * Created: 11.04.2013 22:54:50
 *  Author: Sebastian Weidmann www.weidmann-elektronik.de
 */ 

#include <math.h>
#include <stdint-gcc.h>

#define FIX_MPY(A,B)       ( ( (A) * (B) ) >>15 )
#define LOG2_N_MAX   (10)
#define N_MAX   (1024)   /* maximum number of FFT points */


const int32_t Sinewave[N_MAX]  ={
	0L,    201L,    402L,    603L,    804L,   1005L,   1206L,   1406L,
	1607L,   1808L,   2009L,   2209L,   2410L,   2610L,   2811L,   3011L,
	3211L,   3411L,   3611L,   3811L,   4011L,   4210L,   4409L,   4608L,
	4807L,   5006L,   5205L,   5403L,   5601L,   5799L,   5997L,   6195L,
	6392L,   6589L,   6786L,   6982L,   7179L,   7375L,   7571L,   7766L,
	7961L,   8156L,   8351L,   8545L,   8739L,   8932L,   9126L,   9319L,
	9511L,   9703L,   9895L,  10087L,  10278L,  10469L,  10659L,  10849L,
	11038L,  11227L,  11416L,  11604L,  11792L,  11980L,  12166L,  12353L,
	12539L,  12724L,  12909L,  13094L,  13278L,  13462L,  13645L,  13827L,
	14009L,  14191L,  14372L,  14552L,  14732L,  14911L,  15090L,  15268L,
	15446L,  15623L,  15799L,  15975L,  16150L,  16325L,  16499L,  16672L,
	16845L,  17017L,  17189L,  17360L,  17530L,  17699L,  17868L,  18036L,
	18204L,  18371L,  18537L,  18702L,  18867L,  19031L,  19194L,  19357L,
	19519L,  19680L,  19840L,  20000L,  20159L,  20317L,  20474L,  20631L,
	20787L,  20942L,  21096L,  21249L,  21402L,  21554L,  21705L,  21855L,
	22004L,  22153L,  22301L,  22448L,  22594L,  22739L,  22883L,  23027L,
	23169L,  23311L,  23452L,  23592L,  23731L,  23869L,  24006L,  24143L,
	24278L,  24413L,  24546L,  24679L,  24811L,  24942L,  25072L,  25201L,
	25329L,  25456L,  25582L,  25707L,  25831L,  25954L,  26077L,  26198L,
	26318L,  26437L,  26556L,  26673L,  26789L,  26905L,  27019L,  27132L,
	27244L,  27355L,  27466L,  27575L,  27683L,  27790L,  27896L,  28001L,
	28105L,  28208L,  28309L,  28410L,  28510L,  28608L,  28706L,  28802L,
	28897L,  28992L,  29085L,  29177L,  29268L,  29358L,  29446L,  29534L,
	29621L,  29706L,  29790L,  29873L,  29955L,  30036L,  30116L,  30195L,
	30272L,  30349L,  30424L,  30498L,  30571L,  30643L,  30713L,  30783L,
	30851L,  30918L,  30984L,  31049L,  31113L,  31175L,  31236L,  31297L,
	31356L,  31413L,  31470L,  31525L,  31580L,  31633L,  31684L,  31735L,
	31785L,  31833L,  31880L,  31926L,  31970L,  32014L,  32056L,  32097L,
	32137L,  32176L,  32213L,  32249L,  32284L,  32318L,  32350L,  32382L,
	32412L,  32441L,  32468L,  32495L,  32520L,  32544L,  32567L,  32588L,
	32609L,  32628L,  32646L,  32662L,  32678L,  32692L,  32705L,  32717L,
	32727L,  32736L,  32744L,  32751L,  32757L,  32761L,  32764L,  32766L,
	32767L,  32766L,  32764L,  32761L,  32757L,  32751L,  32744L,  32736L,
	32727L,  32717L,  32705L,  32692L,  32678L,  32662L,  32646L,  32628L,
	32609L,  32588L,  32567L,  32544L,  32520L,  32495L,  32468L,  32441L,
	32412L,  32382L,  32350L,  32318L,  32284L,  32249L,  32213L,  32176L,
	32137L,  32097L,  32056L,  32014L,  31970L,  31926L,  31880L,  31833L,
	31785L,  31735L,  31684L,  31633L,  31580L,  31525L,  31470L,  31413L,
	31356L,  31297L,  31236L,  31175L,  31113L,  31049L,  30984L,  30918L,
	30851L,  30783L,  30713L,  30643L,  30571L,  30498L,  30424L,  30349L,
	30272L,  30195L,  30116L,  30036L,  29955L,  29873L,  29790L,  29706L,
	29621L,  29534L,  29446L,  29358L,  29268L,  29177L,  29085L,  28992L,
	28897L,  28802L,  28706L,  28608L,  28510L,  28410L,  28309L,  28208L,
	28105L,  28001L,  27896L,  27790L,  27683L,  27575L,  27466L,  27355L,
	27244L,  27132L,  27019L,  26905L,  26789L,  26673L,  26556L,  26437L,
	26318L,  26198L,  26077L,  25954L,  25831L,  25707L,  25582L,  25456L,
	25329L,  25201L,  25072L,  24942L,  24811L,  24679L,  24546L,  24413L,
	24278L,  24143L,  24006L,  23869L,  23731L,  23592L,  23452L,  23311L,
	23169L,  23027L,  22883L,  22739L,  22594L,  22448L,  22301L,  22153L,
	22004L,  21855L,  21705L,  21554L,  21402L,  21249L,  21096L,  20942L,
	20787L,  20631L,  20474L,  20317L,  20159L,  20000L,  19840L,  19680L,
	19519L,  19357L,  19194L,  19031L,  18867L,  18702L,  18537L,  18371L,
	18204L,  18036L,  17868L,  17699L,  17530L,  17360L,  17189L,  17017L,
	16845L,  16672L,  16499L,  16325L,  16150L,  15975L,  15799L,  15623L,
	15446L,  15268L,  15090L,  14911L,  14732L,  14552L,  14372L,  14191L,
	14009L,  13827L,  13645L,  13462L,  13278L,  13094L,  12909L,  12724L,
	12539L,  12353L,  12166L,  11980L,  11792L,  11604L,  11416L,  11227L,
	11038L,  10849L,  10659L,  10469L,  10278L,  10087L,   9895L,   9703L,
	9511L,   9319L,   9126L,   8932L,   8739L,   8545L,   8351L,   8156L,
	7961L,   7766L,   7571L,   7375L,   7179L,   6982L,   6786L,   6589L,
	6392L,   6195L,   5997L,   5799L,   5601L,   5403L,   5205L,   5006L,
	4807L,   4608L,   4409L,   4210L,   4011L,   3811L,   3611L,   3411L,
	3211L,   3011L,   2811L,   2610L,   2410L,   2209L,   2009L,   1808L,
	1607L,   1406L,   1206L,   1005L,    804L,    603L,    402L,    201L,
	0L,   -201L,   -402L,   -603L,   -804L,  -1005L,  -1206L,  -1406L,
	-1607L,  -1808L,  -2009L,  -2209L,  -2410L,  -2610L,  -2811L,  -3011L,
	-3211L,  -3411L,  -3611L,  -3811L,  -4011L,  -4210L,  -4409L,  -4608L,
	-4807L,  -5006L,  -5205L,  -5403L,  -5601L,  -5799L,  -5997L,  -6195L,
	-6392L,  -6589L,  -6786L,  -6982L,  -7179L,  -7375L,  -7571L,  -7766L,
	-7961L,  -8156L,  -8351L,  -8545L,  -8739L,  -8932L,  -9126L,  -9319L,
	-9511L,  -9703L,  -9895L, -10087L, -10278L, -10469L, -10659L, -10849L,
	-11038L, -11227L, -11416L, -11604L, -11792L, -11980L, -12166L, -12353L,
	-12539L, -12724L, -12909L, -13094L, -13278L, -13462L, -13645L, -13827L,
	-14009L, -14191L, -14372L, -14552L, -14732L, -14911L, -15090L, -15268L,
	-15446L, -15623L, -15799L, -15975L, -16150L, -16325L, -16499L, -16672L,
	-16845L, -17017L, -17189L, -17360L, -17530L, -17699L, -17868L, -18036L,
	-18204L, -18371L, -18537L, -18702L, -18867L, -19031L, -19194L, -19357L,
	-19519L, -19680L, -19840L, -20000L, -20159L, -20317L, -20474L, -20631L,
	-20787L, -20942L, -21096L, -21249L, -21402L, -21554L, -21705L, -21855L,
	-22004L, -22153L, -22301L, -22448L, -22594L, -22739L, -22883L, -23027L,
	-23169L, -23311L, -23452L, -23592L, -23731L, -23869L, -24006L, -24143L,
	-24278L, -24413L, -24546L, -24679L, -24811L, -24942L, -25072L, -25201L,
	-25329L, -25456L, -25582L, -25707L, -25831L, -25954L, -26077L, -26198L,
	-26318L, -26437L, -26556L, -26673L, -26789L, -26905L, -27019L, -27132L,
	-27244L, -27355L, -27466L, -27575L, -27683L, -27790L, -27896L, -28001L,
	-28105L, -28208L, -28309L, -28410L, -28510L, -28608L, -28706L, -28802L,
	-28897L, -28992L, -29085L, -29177L, -29268L, -29358L, -29446L, -29534L,
	-29621L, -29706L, -29790L, -29873L, -29955L, -30036L, -30116L, -30195L,
	-30272L, -30349L, -30424L, -30498L, -30571L, -30643L, -30713L, -30783L,
	-30851L, -30918L, -30984L, -31049L, -31113L, -31175L, -31236L, -31297L,
	-31356L, -31413L, -31470L, -31525L, -31580L, -31633L, -31684L, -31735L,
	-31785L, -31833L, -31880L, -31926L, -31970L, -32014L, -32056L, -32097L,
	-32137L, -32176L, -32213L, -32249L, -32284L, -32318L, -32350L, -32382L,
	-32412L, -32441L, -32468L, -32495L, -32520L, -32544L, -32567L, -32588L,
	-32609L, -32628L, -32646L, -32662L, -32678L, -32692L, -32705L, -32717L,
	-32727L, -32736L, -32744L, -32751L, -32757L, -32761L, -32764L, -32766L,
	-32767L, -32766L, -32764L, -32761L, -32757L, -32751L, -32744L, -32736L,
	-32727L, -32717L, -32705L, -32692L, -32678L, -32662L, -32646L, -32628L,
	-32609L, -32588L, -32567L, -32544L, -32520L, -32495L, -32468L, -32441L,
	-32412L, -32382L, -32350L, -32318L, -32284L, -32249L, -32213L, -32176L,
	-32137L, -32097L, -32056L, -32014L, -31970L, -31926L, -31880L, -31833L,
	-31785L, -31735L, -31684L, -31633L, -31580L, -31525L, -31470L, -31413L,
	-31356L, -31297L, -31236L, -31175L, -31113L, -31049L, -30984L, -30918L,
	-30851L, -30783L, -30713L, -30643L, -30571L, -30498L, -30424L, -30349L,
	-30272L, -30195L, -30116L, -30036L, -29955L, -29873L, -29790L, -29706L,
	-29621L, -29534L, -29446L, -29358L, -29268L, -29177L, -29085L, -28992L,
	-28897L, -28802L, -28706L, -28608L, -28510L, -28410L, -28309L, -28208L,
	-28105L, -28001L, -27896L, -27790L, -27683L, -27575L, -27466L, -27355L,
	-27244L, -27132L, -27019L, -26905L, -26789L, -26673L, -26556L, -26437L,
	-26318L, -26198L, -26077L, -25954L, -25831L, -25707L, -25582L, -25456L,
	-25329L, -25201L, -25072L, -24942L, -24811L, -24679L, -24546L, -24413L,
	-24278L, -24143L, -24006L, -23869L, -23731L, -23592L, -23452L, -23311L,
	-23169L, -23027L, -22883L, -22739L, -22594L, -22448L, -22301L, -22153L,
	-22004L, -21855L, -21705L, -21554L, -21402L, -21249L, -21096L, -20942L,
	-20787L, -20631L, -20474L, -20317L, -20159L, -20000L, -19840L, -19680L,
	-19519L, -19357L, -19194L, -19031L, -18867L, -18702L, -18537L, -18371L,
	-18204L, -18036L, -17868L, -17699L, -17530L, -17360L, -17189L, -17017L,
	-16845L, -16672L, -16499L, -16325L, -16150L, -15975L, -15799L, -15623L,
	-15446L, -15268L, -15090L, -14911L, -14732L, -14552L, -14372L, -14191L,
	-14009L, -13827L, -13645L, -13462L, -13278L, -13094L, -12909L, -12724L,
	-12539L, -12353L, -12166L, -11980L, -11792L, -11604L, -11416L, -11227L,
	-11038L, -10849L, -10659L, -10469L, -10278L, -10087L,  -9895L,  -9703L,
	-9511L,  -9319L,  -9126L,  -8932L,  -8739L,  -8545L,  -8351L,  -8156L,
	-7961L,  -7766L,  -7571L,  -7375L,  -7179L,  -6982L,  -6786L,  -6589L,
	-6392L,  -6195L,  -5997L,  -5799L,  -5601L,  -5403L,  -5205L,  -5006L,
	-4807L,  -4608L,  -4409L,  -4210L,  -4011L,  -3811L,  -3611L,  -3411L,
	-3211L,  -3011L,  -2811L,  -2610L,  -2410L,  -2209L,  -2009L,  -1808L,
	-1607L,  -1406L,  -1206L,  -1005L,   -804L,   -603L,   -402L,   -201L,
};



void FFT(int32_t fr[], int32_t fi[], int32_t m)
{
   int32_t mr,nn,i,j,l,k,istep, n;
   int32_t qr,qi,tr,ti,wr,wi;

   n = 1<<m;
   mr = 0;
   nn = n - 1;

   /* decimation in time - re-order data */
   for (m=1; m<=nn; ++m) {
      l = n;
      do {
         l >>= 1;
      } while(mr+l > nn);
      mr = (mr & (l-1)) + l;

      if (mr <= m) continue;
      tr = fr[m];
      fr[m] = fr[mr];
      fr[mr] = tr;
      ti = fi[m];
      fi[m] = fi[mr];
      fi[mr] = ti;
   }

   l = 1;
   k = LOG2_N_MAX-1;
   while(l < n) {

      /* it may not be obvious, but the shift will be performed
         on each data point exactly once, during this pass. */
      istep = l << 1;
      for (m=0; m<l; ++m) {
         j = m << k;
         /* 0 <= j < N_MAX/2 */
         
         wr = Sinewave[+(j+N_MAX/4)];
         wi = -(Sinewave[+j]);
		 
         wr >>= 1;
         wi >>= 1;

         for (i=m; i<n; i+=istep) {
            j = i + l;
            tr = (int32_t)FIX_MPY(wr,fr[j]) - (int32_t)FIX_MPY(wi,fi[j]);
            ti = (int32_t)FIX_MPY(wr,fi[j]) + (int32_t)FIX_MPY(wi,fr[j]);
            qr = fr[i];
            qi = fi[i];
            qr >>= 1;
            qi >>= 1;

            fr[j] = qr - tr;
            fi[j] = qi - ti;
            fr[i] = qr + tr;
            fi[i] = qi + ti;
         }
      }
      --k;
      l = istep;
   }
} /* end of FixFFT() */
